#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <string>
#include <algorithm>
#include <cmath>
#include <time.h>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <map>
#include <cstdio>
#include <assert.h>
#include <cstdlib>
#include <cstring>

using namespace std;

typedef long long ll;
typedef double db;
typedef string str;
typedef unsigned int uint;

#define forn(i, n) for (int i = 0; i < n; ++i) 
#define INF 1e+9
#define EPS 1e-9
#define PI 3.1415926535897932384626433832795
#define mp(a, b) make_pair(a, b)
#define pb(a) push_back(a)
#define pii pair<int, int>
#define pll pair<ll, ll>
#define pdd pair<db, db>
#define sz(a) ( (int) a.size() )
#define len(a) ( (int) a.length() )
#define ms(x) memset(x, 0, sizeof(x))
#define ms1(x) memset(x, -1, sizeof(x))
#define L(a) sz(a)
#define X first
#define Y second
#define ALL(a) a.begin(), a.end()

double calc(vector<pdd> points){
	vector<pair<double, int>> ev(sz(points) * 2);
	int cnt = 0;
	forn(i, sz(points)){
		ev[cnt++] = mp(points[i].X,0);
		ev[cnt++] = mp(points[i].Y,1);
	}
	sort(ALL(ev));
	double curbeg = -1e+9;
	double best = 0;
	int bal = 0;
	forn(i, sz(ev)){
		if (ev[i].Y == 0) {
			if (bal == 0) curbeg = ev[i].X;
			bal++;
		}
		if (ev[i].Y == 1) bal--;
		if (bal == 0){
			best = max(best, ev[i].X - curbeg);
		}
	}
	return best;
}

bool solve(){
	int n;
	scanf("%d", &n);
	if (!n) return false;
	vector<pdd> mas(n);
	double l = 0, r = 0;
	forn(i, n){
		scanf("%lf%lf", &mas[i].X, &mas[i].Y);
		r = max(r, mas[i].Y);
	}
	r++;
	forn(iter, 25){
		double m = (l + r) * .5;
		vector<pdd> points;
		forn(i, n){
			double cur = mas[i].Y * mas[i].Y - m * m;
			if (cur <= 0) continue;
			cur = sqrt(cur);
			points.pb(mp(mas[i].X - cur, mas[i].X + cur));
		}
		double dd = calc(points);
		if (dd >= 2 * m) l = m;
		else r = m;
	}
	printf("%.15lf\n", 2*l);
	return true;
}

int main(){
#ifdef _DEBUG
    freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
#else
    /*freopen(".in", "r", stdin);
    freopen(".out", "w", stdout);*/
#endif
	while(solve());
#ifdef _DEBUG
    cout << fixed << setprecision(15) << "\n" << clock() * 1.0 / CLOCKS_PER_SEC;
#endif
    return 0;
}